Attribute VB_Name = "GpibCntrl"
Option Explicit

Public RecvBuffer As String * 65525 'Receive buffer

'Variable define
Public Gpib_Dd(30) As Integer       'GPIB device descriptor.
Public U38_GpibAddress As Long
Public SG_GpibAddress As Long
Public SG_OutputLevel As Single

Public SG_OUTPUT__CMD As String
Public SG_OUT_ON__CMD As String
Public SG_OUT_OFF_CMD As String
Public SG_OUT_LVL_CMD As String
Public SG_OUT_LVL_UNT As String
Public SG_SET_FRQ_CMD As String
Public SG_SET_FRQ_UNT As String

Public GpibConnect As Boolean       'GPIB Connect flag. (False : OFF, True : ON)
Public VCorrAbort As Boolean        'External SG Vector Correction Abort flag. (Abort : True, Not Abort : False)

Global Const BoName = "GPIB0"       'GPIB Board Name
Global Boid As Integer              'Board
Global Const OK = 0
Global Const NG = -1
Global Const GPIB_ERROR = &H8000    ' ibsta ERR bit
Public Const BdIndx = 0             '


'
'Clear GPIB device descriptor
'
Public Sub ClrGpibDd()
    Dim i As Integer
    
    For i = 0 To 30
        Gpib_Dd(i) = 0
    Next i
End Sub

'
' GPIB open
'
Public Function OpenGpib(Adrs As Long) As Long
        
    Call ibdev(0, Adrs, 0, T10s, 1, 0, Gpib_Dd(Adrs))   'GPIB Addr Time out=10sec
    'GPIBerr = 0
    OpenGpib = CLng(iberr)
End Function

'
'GPIB close
'
Public Sub CloseGpib(Adrs As Long)
    Dim rtn As Long

    If 0 > Adrs And Gpib_Dd(Adrs) > 0 Then Exit Sub
    Call ibloc(Gpib_Dd(Adrs))
    Call ibonl(Gpib_Dd(Adrs), 0)
    Gpib_Dd(Adrs) = 0
End Sub

'
'GPIB send
'
Public Function PutGpib(Adrs As Long, str As String) As Long
    Dim cmd As String
    cmd = "_?@" + Chr(Adrs + 32)     ' UNT,UNL,MTA0,LISTEN x
    Call ibcmd(Gpib_Dd(Adrs), cmd)
    Call ibwrt(Gpib_Dd(Adrs), str & vbLf)
    PutGpib = CLng(iberr)
End Function

'
'GPIB receive
'
Public Function GetGpib(Adrs As Long, str As String) As Long
    Dim cmd As String

    cmd = "_? " + Chr(Adrs + 64)     ' UNT,UNL,MLA0,TALK x
    Call ibcmd(Gpib_Dd(Adrs), cmd)
    Call ibrd(Gpib_Dd(Adrs), str)
    GetGpib = CLng(iberr)
End Function

'
'GPIB send & receive
'
Public Function QryGpib(Adrs As Long, Send_str As String, Receive_str As String) As Long
    QryGpib = PutGpib(Adrs, Send_str)
    If QryGpib < 0 Then Exit Function
    QryGpib = GetGpib(Adrs, RecvBuffer)
    Receive_str = Mid(RecvBuffer, 1, InStr(RecvBuffer, vbLf))
End Function

